<?php
$id = 'wds-welcome-modal';
$types_builder_url = Smartcrawl_Settings_Admin::admin_url( Smartcrawl_Settings::TAB_SCHEMA ) . '&tab=tab_types&add_type=1';
?>

<div class="sui-modal sui-modal-md">
	<div role="dialog"
	     id="<?php echo esc_attr( $id ); ?>"
	     class="sui-modal-content <?php echo esc_attr( $id ); ?>-dialog"
	     aria-modal="true"
	     aria-labelledby="<?php echo esc_attr( $id ); ?>-dialog-title"
	     aria-describedby="<?php echo esc_attr( $id ); ?>-dialog-description">

		<div class="sui-box" role="document">
			<div class="sui-box-header sui-flatten sui-content-center sui-spacing-top--40">
				<div class="sui-box-banner" role="banner" aria-hidden="true">
					<img src="<?php echo esc_attr( SMARTCRAWL_PLUGIN_URL ); ?>assets/images/graphic-upgrade-header.svg"/>
				</div>

				<button class="sui-button-icon sui-button-float--right" data-modal-close
				        id="<?php echo esc_attr( $id ); ?>-close-button"
				        type="button">
					<span class="sui-icon-close sui-md" aria-hidden="true"></span>
					<span class="sui-screen-reader-text"><?php esc_html_e( 'Close this dialog window', 'wds' ); ?></span>
				</button>

				<h3 class="sui-box-title sui-lg"
				    id="<?php echo esc_attr( $id ); ?>-dialog-title">

					<?php esc_html_e( 'NEW: Google Lighthouse SEO test', 'wds' ); ?>
				</h3>

				<div class="sui-box-body sui-content-center">
					<p class="sui-description"
					   id="<?php echo esc_attr( $id ); ?>-dialog-description">
						<span>
							<?php echo smartcrawl_format_link(
								esc_html__( "%s is an open-source, automated SEO scanning tool to help you improve the quality of your web pages. It runs on your Homepage to provide you with a detailed analysis, including tips and useful guidance to drastically improve your SEO score.", 'wds' ),
								'https://developers.google.com/web/tools/lighthouse',
								esc_html__( 'Google Lighthouse', 'wds' ),
								'_blank'
							); ?>
						</span>
					</p>

					<p class="sui-description">
						<span>
							<?php echo smartcrawl_format_link(
								esc_html__( "SmartCrawl's SEO Checkup tool will be shut down after a few releases. We recommend you %s now to get the best of the web on your own site, and ensure your site is always optimized for search engine results ranking.", 'wds' ),
								Smartcrawl_Settings_Admin::admin_url( Smartcrawl_Settings::TAB_HEALTH ) . '&tab=tab_settings#seo-test-mode',
								esc_html__( 'switch to Lighthouse', 'wds' ),
								'_blank'
							); ?>
						</span>
					</p>

					<button id="<?php echo esc_attr( $id ); ?>-get-started" type="button" class="sui-button">
						<span class="sui-loading-text">
							<?php esc_html_e( 'Got it', 'wds' ); ?>
						</span>
						<span class="sui-icon-loader sui-loading" aria-hidden="true"></span>
					</button>
				</div>
			</div>
		</div>

		<a style="display: none;" id="<?php echo esc_attr( $id ); ?>-skip"
		   href="#">

			<?php esc_html_e( 'Skip This', 'wds' ); ?>
		</a>
	</div>
</div>
