<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * The "configurations" collection of methods.
 * Typical usage is:
 *  <code>
 *   $runService = new Google_Service_CloudRun(...);
 *   $configurations = $runService->configurations;
 *  </code>
 */
class Google_Service_CloudRun_Resource_NamespacesConfigurations extends Google_Service_Resource
{
  /**
   * Create a configuration. (configurations.create)
   *
   * @param string $parent The project ID or project number in which this
   * configuration should be created.
   * @param Google_Service_CloudRun_Configuration $postBody
   * @param array $optParams Optional parameters.
   * @return Google_Service_CloudRun_Configuration
   */
  public function create($parent, Google_Service_CloudRun_Configuration $postBody, $optParams = array())
  {
    $params = array('parent' => $parent, 'postBody' => $postBody);
    $params = array_merge($params, $optParams);
    return $this->call('create', array($params), "Google_Service_CloudRun_Configuration");
  }
  /**
   * delete a configuration. This will cause the configuration to delete all child
   * revisions. Prior to calling this, any route referencing the configuration (or
   * revision from the configuration) must be deleted. (configurations.delete)
   *
   * @param string $name The name of the configuration being deleted. If needed,
   * replace {namespace_id} with the project ID.
   * @param array $optParams Optional parameters.
   *
   * @opt_param string apiVersion Cloud Run currently ignores this parameter.
   * @opt_param string propagationPolicy Specifies the propagation policy of
   * delete. Cloud Run currently ignores this setting, and deletes in the
   * background. Please see kubernetes.io/docs/concepts/workloads/controllers
   * /garbage-collection/ for more information.
   * @opt_param string kind Cloud Run currently ignores this parameter.
   * @return Google_Service_CloudRun_K8sIoApimachineryPkgApisMetaV1Status
   */
  public function delete($name, $optParams = array())
  {
    $params = array('name' => $name);
    $params = array_merge($params, $optParams);
    return $this->call('delete', array($params), "Google_Service_CloudRun_K8sIoApimachineryPkgApisMetaV1Status");
  }
  /**
   * Get information about a configuration. (configurations.get)
   *
   * @param string $name The name of the configuration being retrieved. If needed,
   * replace {namespace_id} with the project ID.
   * @param array $optParams Optional parameters.
   * @return Google_Service_CloudRun_Configuration
   */
  public function get($name, $optParams = array())
  {
    $params = array('name' => $name);
    $params = array_merge($params, $optParams);
    return $this->call('get', array($params), "Google_Service_CloudRun_Configuration");
  }
  /**
   * List configurations. (configurations.listNamespacesConfigurations)
   *
   * @param string $parent The project ID or project number from which the
   * configurations should be listed.
   * @param array $optParams Optional parameters.
   *
   * @opt_param int limit The maximum number of records that should be returned.
   * @opt_param bool watch Flag that indicates that the client expects to watch
   * this resource as well. Not currently used by Cloud Run.
   * @opt_param string labelSelector Allows to filter resources based on a label.
   * Supported operations are =, !=, exists, in, and notIn.
   * @opt_param string resourceVersion The baseline resource version from which
   * the list or watch operation should start. Not currently used by Cloud Run.
   * @opt_param bool includeUninitialized Not currently used by Cloud Run.
   * @opt_param string fieldSelector Allows to filter resources based on a
   * specific value for a field name. Send this in a query string format. i.e.
   * 'metadata.name%3Dlorem'. Not currently used by Cloud Run.
   * @opt_param string continue Optional encoded string to continue paging.
   * @return Google_Service_CloudRun_ListConfigurationsResponse
   */
  public function listNamespacesConfigurations($parent, $optParams = array())
  {
    $params = array('parent' => $parent);
    $params = array_merge($params, $optParams);
    return $this->call('list', array($params), "Google_Service_CloudRun_ListConfigurationsResponse");
  }
  /**
   * Replace a configuration.
   *
   * Only the spec and metadata labels and annotations are modifiable. After the
   * Update request, Cloud Run will work to make the 'status' match the requested
   * 'spec'.
   *
   * May provide metadata.resourceVersion to enforce update from last read for
   * optimistic concurrency control. (configurations.replaceConfiguration)
   *
   * @param string $name The name of the configuration being retrieved. If needed,
   * replace {namespace_id} with the project ID.
   * @param Google_Service_CloudRun_Configuration $postBody
   * @param array $optParams Optional parameters.
   * @return Google_Service_CloudRun_Configuration
   */
  public function replaceConfiguration($name, Google_Service_CloudRun_Configuration $postBody, $optParams = array())
  {
    $params = array('name' => $name, 'postBody' => $postBody);
    $params = array_merge($params, $optParams);
    return $this->call('replaceConfiguration', array($params), "Google_Service_CloudRun_Configuration");
  }
}
