/**
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */




document.addEventListener('DOMContentLoaded', function() {
    var videoContainer = document.querySelector('.vidbg-container');
    var video = document.createElement('video');
    video.setAttribute('playsinline', '');
    video.setAttribute('autoplay', '');
    video.setAttribute('loop', '');
    video.setAttribute('muted', '');
    video.setAttribute('style', 'opacity: 1; width: 100%; height: auto;');

    var sourceMp4 = document.createElement('source');
    sourceMp4.setAttribute('src', 'https://pixelshealth.com/wp-content/uploads/2021/10/BannerPixelsHealth4.mp4');
    sourceMp4.setAttribute('type', 'video/mp4');
    video.appendChild(sourceMp4);

    var sourceWebm = document.createElement('source');
    sourceWebm.setAttribute('src', 'https://pixelshealth.com/wp-content/uploads/2022/12/BannerPixelsHealth4.webm');
    sourceWebm.setAttribute('type', 'video/webm');
    video.appendChild(sourceWebm);

    videoContainer.appendChild(video);

    // Ajouter une classe au conteneur vidéo en fonction de la taille de l'écran
    function updateVideoContainerClass() {
        var screenWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;

        if (screenWidth <= 768) {
            videoContainer.classList.add('responsive-video');
        } else {
            videoContainer.classList.remove('responsive-video');
        }
    }

    updateVideoContainerClass();

    // Mettre à jour la classe du conteneur vidéo lors du redimensionnement de l'écran
    window.addEventListener('resize', function() {
        updateVideoContainerClass();
    });
});








( function( $ ) {
	'use strict';
	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );
	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				} );
			} else {
				$( '.site-title, .site-description' ).css( {
					'clip': 'auto',
					'color': to,
					'position': 'relative'
				} );
			}
		} );
	} );
} )( jQuery );
